% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{get_idf}
\alias{get_idf}
\title{Inverse document-frequency scaling matrix}
\usage{
get_idf(dtm, log_scale = log, smooth_idf = TRUE)
}
\arguments{
\item{dtm}{a document-term matrix of class \code{dgCMatrix} or
\code{dgTMatrix}.}

\item{log_scale}{\code{function} to use in calculating the IDF matrix.
Usually \link{log} is used, but it might be worth trying \link{log2}.}

\item{smooth_idf}{\code{logical} smooth IDF weights by adding one to document
frequencies, as if an extra document was seen containing every term in the
collection exactly once. This prevents division by zero.}
}
\value{
\code{ddiMatrix} IDF scaling diagonal sparse matrix.
}
\description{
This function creates an inverse-document-frequency (IDF)
  scaling matrix from a document-term matrix. The IDF is defined as follows:
  \code{idf = log(# documents in the corpus) / (# documents where the term
  appears + 1)}
}
\seealso{
\link{get_tf}, \link{get_dtm}, \link{create_dtm}
}

