% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_RWMD.R
\docType{data}
\name{RelaxedWordMoversDistance}
\alias{RWMD}
\alias{RelaxedWordMoversDistance}
\title{Creates model which can be used for calculation of "relaxed word movers distance".}
\format{\code{\link{R6Class}} object.}
\usage{
RelaxedWordMoversDistance

RWMD
}
\description{
Relaxed word movers distance tries to measure distance between documents by
calculating how hard is to transofrm words from first document into words from second document
and vice versa. For more detail see original article: \url{http://mkusner.github.io/publications/WMD.pdf}.
}
\section{Fields}{

\describe{
\item{\code{verbose}}{\code{logical = TRUE} whether to display
additional inforamtion during calculations.}
}}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
rwmd = RelaxedWordMoversDistance$new(wv, method = c("cosine", "euclidean"))
rwmd$dist2(x, y)
rwmd$pdist2(x, y)
}
}

\section{Methods}{

\describe{
  \item{\code{$new(wv, method = c("cosine", "euclidean"))}}{Constructor for RWMD model
        For description of arguments see \bold{Arguments} section}
  \item{\code{$dist2(x, y)}}{Computes distance between each row of sparse matrix
        \code{x} and each row of sparse matrix \code{y}}
  \item{\code{$pdist2(x, y)}}{Computes "parallel" distance between rows of
        sparse matrix \code{x} and corresponding rows of the sparse matrix \code{y}}
}
}

\section{Arguments}{

\describe{
 \item{rwmd}{\code{RWMD} object}
 \item{x}{\code{x} sparse document term matrix}
 \item{y}{\code{y = NULL} sparse document term matrix.
         If \code{y = NULL} (as by default), we will assume \code{y = x} }
 \item{wv}{word vectors. Numeric matrix which contains word embeddings. Rows - words,
           columns - corresponding vectors. Rows should have word names.}
 \item{method}{name of the distance for measuring similarity between two word vectors.
               In original paper authors use \code{"euclidean"},
               however we use \code{"cosine"} by default (better from our experience).
               This means \code{distance = 1 - cosine_angle_betwen_wv}}
}
}
\examples{
\dontrun{
data("movie_review")
tokens = movie_review$review \%>\%
  tolower \%>\%
  word_tokenizer
v = create_vocabulary(itoken(tokens)) \%>\%
  prune_vocabulary(term_count_min = 5, doc_proportion_max = 0.5)
corpus = create_corpus(itoken(tokens), vocab_vectorizer(v, skip_grams_window = 5))
dtm = get_dtm(corpus)
tcm = get_tcm(corpus)
glove_model = GloVe$new(word_vectors_size = 50, vocabulary = v, x_max = 10)
wv = glove_model$fit(tcm, n_iter = 10)
rwmd_model = RWMD(wv)
rwmd_dist = dist2(dtm[1:10, ], dtm[1:100, ], method = rwmd_model, norm = 'none')
}
}
\keyword{datasets}

