% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-dtm.R
\name{dtm_resampler}
\alias{dtm_resampler}
\title{Resamples an input DTM to generate new DTMs}
\usage{
dtm_resampler(dtm, alpha = 1)
}
\arguments{
\item{dtm}{Document-term matrix with words as columns. Works with DTMs
produced by any popular text analysis package, or you can use the
\code{dtm_builder()} function.}

\item{alpha}{a proportion of document tokens. Default = 1, or the full
document lengths.}
}
\value{
returns a document-term matrix of class "dgCMatrix"
}
\description{
Takes any DTM and randomly resamples from each row, creating a new DTM
}
\details{
Using the row counts as probabilities, each document's tokens are resampled
with replacement up to a certain proportion of the row count (set by alpha).
This function can be used with iteration to "bootstrap" a DTM without
returning to the raw text. It does not iterate, however, so operations can
be performed on one DTM at a time without storing multiple DTMs in memory.
}
