% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_2_textTopicsAnalysis.R
\name{textTopicsWordcloud}
\alias{textTopicsWordcloud}
\title{This functions plots wordclouds of topics from a Topic Model based on their significance
determined by a linear or binary regression}
\usage{
textTopicsWordcloud(
  model,
  test,
  color_negative_cor = ggplot2::scale_color_gradient(low = "darkred", high = "red"),
  color_positive_cor = ggplot2::scale_color_gradient(low = "darkgreen", high = "green"),
  scale_size = FALSE,
  plot_topics_idx = NULL,
  p_threshold = 0.05
)
}
\arguments{
\item{model}{(data.frame) The model returned from textTopics().}

\item{test}{(data.frame) the test returned from textTopicTest()}

\item{color_negative_cor}{(ggplot2::scale_color_gradient()) color gradient of topic cloud
with negative correlation}

\item{color_positive_cor}{(ggplot2::scale_color_gradient) color gradient of topic cloud
with positive correlation}

\item{scale_size}{(bool) if True, then the size of the topic cloud is scaled by the
prevalence of the topic}

\item{plot_topics_idx}{(list) if specified, then only the specified topics are plotted}

\item{p_threshold}{(float) set significance threshold which determines which topics are plotted}
}
\description{
This functions plots wordclouds of topics from a Topic Model based on their significance
determined by a linear or binary regression
}
