% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,gel-method}
\alias{extract,gel-method}
\alias{extract.gel}
\title{\code{\link{extract}} method for \code{gel} objects}
\usage{
\S4method{extract}{gel}(
  model,
  include.obj.fcn = TRUE,
  include.overidentification = FALSE,
  include.nobs = TRUE,
  overIdentTest = c("LR", "LM", "J "),
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.obj.fcn}{Report the value of the objective function
(= criterion function)? More precisely, this returns
\code{E(g)var(g)^{-1}E(g)}.}

\item{include.overidentification}{Report the J-test for overidentification?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{overIdentTest}{Which test statistics should be included in an
overidentification test?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{gel} objects created by the
\code{\link[gmm]{gel}} function in the \pkg{gmm} package.
}
