% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,tobit-method}
\alias{extract,tobit-method}
\alias{extract.tobit}
\title{\code{\link{extract}} method for \code{tobit} objects}
\usage{
\S4method{extract}{tobit}(
  model,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.deviance = TRUE,
  include.nobs = FALSE,
  include.censnobs = TRUE,
  include.wald = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.deviance}{Report the deviance?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.censnobs}{Report the total, right-censored, left-censored, and
uncensored number of observations?}

\item{include.wald}{Report the Wald statistic?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{tobit} objects created by the
\code{\link[AER]{tobit}} function in the \pkg{AER} package.
}
