% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/article-tools.R
\name{produce_html}
\alias{produce_html}
\title{call rmarkdown::render to generate html file}
\usage{
produce_html(
  article_dir,
  example = FALSE,
  web_dir = TRUE,
  interactive_mode = FALSE
)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}

\item{example}{only enabled for running examples for documentation and
to enable export of this function.}

\item{web_dir}{option to create a new web directory, default TRUE}

\item{interactive_mode}{interactive mode for converting articles with options. default FALSE}
}
\value{
Renders a RJwrapper.html file in the /web folder, in example it will
return TRUE
}
\description{
call rmarkdown::render to generate html file
}
\note{
Use pandoc version greater than or equal to 3.1

Do not set example = TRUE param when working with conversions.

example param is set TRUE in example, to conform with CRAN check restrictions.
}
\examples{
# Note This is a minimal example to execute this function
article_dir <- system.file("examples/article",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"article",sep="/")
texor::include_style_file(your_article_path)
rmarkdown::pandoc_version()
texor::convert_to_markdown(your_article_path)
texor::generate_rmd(your_article_path)
texor::copy_other_files(your_article_path)
texor::produce_html(your_article_path,example = TRUE)
unlink(your_article_folder,recursive = TRUE)
}
