% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpdRangeFit.R
\name{gpdRangeFit}
\alias{ggplot.gpdRangeFit}
\alias{gpdRangeFit}
\alias{plot.gpdRangeFit}
\alias{print.gpdRangeFit}
\alias{print.summary.gpdRangeFit}
\alias{summary.gpdRangeFit}
\title{Estimate generalized Pareto distribution parameters over a range of values}
\usage{
gpdRangeFit(data, umin=quantile(data, .05), umax=quantile(data, .95),
nint = 10, penalty = "gaussian", priorParameters = NULL, alpha=0.05,
cov="observed")
\method{print}{gpdRangeFit}(x, ...)
\method{summary}{gpdRangeFit}(object, ...)
\method{print}{summary.gpdRangeFit}(x, ...)
\method{plot}{gpdRangeFit}(x, xlab = "Threshold", ylab = NULL, main = NULL, addNexcesses=TRUE, ...)
\method{ggplot}{gpdRangeFit}(data, mapping, xlab="Threshold", ylab=NULL,
main=NULL, fill="orange", col="blue", addNexcesses = TRUE, textsize=4, ...,
environment)
}
\arguments{
\item{data}{The data vector to be modelled.}

\item{umin}{The minimum threshold above which to estimate the parameters.}

\item{umax}{The maximum threshold above which to estimate the parameters.}

\item{nint}{The number of thresholds at which to perform the estimation.}

\item{penalty}{The type of penalty to be used in the maximum penalized
likelihood estimation. Should be either "gaussian" or "none". Defaults to
"gaussian".}

\item{priorParameters}{Parameters to be used for the penalty function.  See
the help for \code{\link{evm}} for more informaiton.}

\item{alpha}{100(1 - alpha)\% confidence intervals will be plotted with the
point estimates. Defaults to \code{alpha = 0.05}.}

\item{cov}{How to compute the covariance matrix of the parameters. Defaults
to \code{cov = "observed"} in which case the observed information matrix is
used, if the \code{info} element of the \code{texmexFamily} object is
present. See more detailed documentation of this argument in
\code{\link{evm}}.}

\item{x, object}{Arguments to \code{print} and \code{summary} functions.}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{main}{The main title.}

\item{addNexcesses}{Annotate top axis with numbers of threshold excesses
arising with the corresponding values of threshold on the bottom axis.}

\item{col}{Colour of the line on the threshold stability plot.}

\item{fill}{Colour of the pointwise confidence region on the threshold
stability plots.}

\item{textsize}{Size of text on the plot (ggplot). Defaults to
\code{textsize=4}.}

\item{\dots}{Arguments to \code{plot}.}

\item{mapping, environment}{Not used.}
}
\description{
Estimate generalized Pareto distribution parameters over a range of values,
using maximum (penalized) likelihood.
}
\details{
This is Stuart Coles' \code{gpd.fitrange}, as it appears in the \code{ismev}
package, refactored into a function that does the computations, and method
functions. The function uses \code{evm} internally and uses the default
options for that function.

Note this function does not extend to assessing model fit when there are
covariates included in the model.
}
\examples{

par(mfrow=c(1,2))
plot(gpdRangeFit(rain))

}
\author{
Stuart Coles, Janet E Heffernan, Harry Southworth
}
\seealso{
\code{\link{evm}}
}
\keyword{models}

