% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinAndBurn.evm.sim.R
\name{thinAndBurn}
\alias{thinAndBurn}
\alias{thinAndBurn.evmSim}
\title{Process Metropolis output from extreme value model fitting to discard
unwanted observations.}
\usage{
\method{thinAndBurn}{evmSim}(object, burn, thin)
}
\arguments{
\item{object}{Object of class 'evmSim' as returned by \code{evm} called with
\code{method="simulate"}.}

\item{burn}{The number of observations from the simulated Markov Chain to be
discarded as burn-in. Must be a non-negative integer, for no burn-in use
\code{burn=0}.}

\item{thin}{\code{thin} or its reciprocal must be a positive integer.  If
integer valued, this specifies the frequency of observations from the
simulated Markov Chain which will be retained.  If specified as a
proportion, this is the proportion of values which will be retained. For no
thinning use \code{thin=1}.}
}
\value{
Object of class \code{evmSim}.  See Value returned by
\code{\link{evm}} using \code{method = "simulate"} for details.

Note that the original chain is not discarded when this function is called:
\code{thinAndBurn} can be called recursively on the original object with
different values of \code{burn} and \code{thin} without the object getting
progressively smaller!
}
\description{
Process observations from Metropolis fitting of extreme value models, to
thin the output and discard observations from burn-in period.
}
\examples{

  x <- rnorm(1000)
  # For the values of burn and thin below, we should do many more iterations.
  # The number of iterations is kept low here due to the run time allowed
  # by CRAN.
  mod <- evm(x, qu=.7, method="sim", iter=11000)
  mod
  par(mfrow=c(3, 2))
  plot(mod)
  mod1 <- thinAndBurn(mod,burn=1000, thin=5)
  plot(mod1)

}
\author{
Harry Southworth, Janet E. Heffernan
}
\seealso{
\code{\link{evm}}
}

