\name{methods}
\alias{coef.bgpd}
\alias{coef.mex}
\alias{coef.migpd}
\alias{coefficients.bgpd}
 \alias{coefficients.gpd}
 \alias{coefficients.mex}
 \alias{coefficients.migpd}
 \alias{plot.extremalIndex}
 \alias{print.MCS}
 \alias{print.bootMCS}
 \alias{print.chi}
 \alias{print.copula}
 \alias{print.declustered}
 \alias{print.extremalIndex}
 \alias{print.mex}
 \alias{print.mexDependence}
 \alias{print.migpd}
 \alias{print.predict.mex}
 \alias{print.summary.bgpd}
 \alias{print.summary.gpd}
 \alias{print.summary.predict.mex}
 \alias{show.MCS}
 \alias{show.bootMCS}
 \alias{show.copula}
 \alias{show.declustered}
 \alias{show.extremalIndex}
 \alias{show.mex}
 \alias{show.mexDependence}
 \alias{show.migpd}
 \alias{show.predict.mex}
 \alias{show.summary.bgpd}
 \alias{show.summary.gpd}
 \alias{show.summary.predict.mex}
 \alias{summary.MCS}
 \alias{summary.bgpd}
 \alias{summary.copula}
 \alias{summary.mex}
 \alias{summary.migpd}
 
\title{ Methods for texmex objects}
\description{
  Methods for texmex objects.
}
\usage{

\method{coef}{bgpd}(object,...)
\method{coef}{mex}(object,...)
\method{coef}{migpd}(object,...)
\method{coefficients}{bgpd}(object,...)
 \method{coefficients}{gpd}(object,...)
 \method{coefficients}{mex}(object,...)
 \method{coefficients}{migpd}(object,...)
 \method{plot}{extremalIndex}(x,...)
 \method{print}{MCS}(x,...)
 \method{print}{bootMCS}(x,...)
 \method{print}{chi}(x,...)
 \method{print}{copula}(x,...)
 \method{print}{declustered}(x,...)
 \method{print}{extremalIndex}(x,...)
 \method{print}{mex}(x,...)
 \method{print}{mexDependence}(x,...)
 \method{print}{migpd}(x,...)
 \method{print}{predict.mex}(x,...)
 \method{print}{summary.bgpd}(x,...)
 \method{print}{summary.gpd}(x,digits=3,...)
 \method{print}{summary.predict.mex}(x,...)
 \method{show}{MCS}(x,...)
 \method{show}{bootMCS}(x,...)
 \method{show}{copula}(x,...)
 \method{show}{declustered}(x,...)
 \method{show}{extremalIndex}(x,...)
 \method{show}{mex}(x,...)
 \method{show}{mexDependence}(x,...)
 \method{show}{migpd}(x,...)
 \method{show}{predict.mex}(x,...)
 \method{show}{summary.bgpd}(x,...)
 \method{show}{summary.gpd}(x,digits=3,...)
 \method{show}{summary.predict.mex}(x,...)
 \method{summary}{MCS}(object,...)
 \method{summary}{bgpd}(object,...)
 \method{summary}{copula}(object,...)
 \method{summary}{mex}(object,...)
 \method{summary}{migpd}(object,verbose=TRUE,...)
}

\arguments{
  \item{x}{ A texmex object of class indicated by method type. }
  \item{object}{ A texmex object of class indicated by method type.}
  \item{digits}{ Number of digits for printing.}
  \item{verbose}{ Logical, whether to show model fitting summary in addition to just model parameter estimates.}
  \item{...}{Further arguments to methods.}
  }

\author{ Harry Southworth, Janet E. Heffernan }

