% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\docType{data}
\name{tex_opts}
\alias{tex_opts}
\alias{tex_opts_current}
\title{Default and current tex options}
\format{
An object of class \code{list} of length 5.

An object of class \code{list} of length 5.
}
\usage{
tex_opts

tex_opts_current
}
\description{
Options for functions in the texPreview package. When running R code, the object \code{tex_opts}
(default options) is not modified by chunk headers (local chunk options are
merged with default options), whereas \code{tex_opts_current} (current options)
changes with different chunk headers and it always reflects the options for
the current chunk.
}
\details{
Normally we set up the global options once in the first code chunk in a
document using \code{tex_opts$set()}, so that all \emph{latter} chunks will
use these options. Note the global options set in one chunk will not affect
the options in this chunk itself, and that is why we often need to set global
options in a separate chunk.

Below is a list of default chunk options, retrieved via
\code{tex_opts$get()}:

These options correspond to fields in the direct call to \code{\link{tex_preview}}, which are listed in explained

in the help manual.
}
\note{
\code{tex_opts_current} is read-only in the sense that it does nothing if
you call \code{tex_opts_current$set()}; you can only query the options via
\code{tex_opts_current$get()}.
}
\examples{
tex_opts$get()
}
\concept{opts}
\keyword{datasets}
