% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-chk.R
\name{pattern-expectations}
\alias{pattern-expectations}
\alias{expect_regex}
\alias{expect_max_length}
\title{Expectations: patterns}
\usage{
expect_regex(vars, pattern, flt = TRUE, data = get_testdata())

expect_max_length(vars, len, flt = TRUE, data = get_testdata())
}
\arguments{
\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{pattern}{A \link[stringr:str_detect]{str_detect()} pattern to match.}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}

\item{len}{Maximum string length.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
Test whether variables in a data frame conform to a given pattern.
}
\examples{

sales <- data.frame(
  sale_id = 1:5,
  item_code = c("a_1", "b_2", "c_2", NA, "NULL")
)

try(expect_regex(item_code, "[a-z]_[0-9]", data = sales)) # Codes match regex
try(expect_max_length(item_code,  3, data = sales)) # Code width <= 3

}
\seealso{
\link[=chk-patterns]{Checks: patterns}

Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{datacomp-expectations}},
\code{\link{date-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{proportion-expectations}},
\code{\link{text-expectations}},
\code{\link{uniqueness-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
