% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-expect.R
\name{expect-deprec}
\alias{expect-deprec}
\alias{expect_func}
\alias{expect_join}
\alias{expect_similar}
\title{Deprecated expectation functions}
\usage{
expect_func(var, ...)

expect_join(data2, by = NULL, not = FALSE, flt = TRUE, data = get_testdata())

expect_similar(
  var,
  data2,
  var2,
  flt = TRUE,
  flt2 = flt,
  threshold = 0.05,
  min = 100,
  data = get_testdata()
)
}
\arguments{
\item{var}{An unquoted column name to test.}

\item{...}{Arguments to pass to \code{expect_allany()}.}

\item{data2}{The data frame to compare against.}

\item{by}{A character vector of columns to join by. See \code{\link[dplyr:mutate-joins]{dplyr::join()}} for
details.}

\item{not}{Reverse the results of the check?}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}

\item{var2}{An unquoted column name from data2.}

\item{flt2}{A filter specifying a subset of data2 to test.}

\item{threshold}{The maximum proportional difference allowed between the two
categories.}

\item{min}{The minimum number of responses for a category to allow
comparison. This avoids small categories raising spurious errors.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}}

These functions are deprecated.
}
\seealso{
\link[=generic-expectations]{Generic Expectation Functions}

\link[=datacomp-expectations]{Expectations: comparisons}
}
\keyword{internal}
