% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tesseract.R
\name{ocr}
\alias{ocr}
\alias{tesseract}
\alias{tesseract}
\title{Tesseract OCR}
\usage{
ocr(image, engine = tesseract())

tesseract(language = NULL, datapath = NULL, cache = TRUE)
}
\arguments{
\item{image}{file path, url, or raw vector to image (png, tiff, jpeg, etc)}

\item{engine}{a tesseract engine created with \code{tesseract()}}

\item{language}{string with language for training data. Usually defaults to \code{eng}}

\item{datapath}{path with the training data for this language. Default uses
the system library.}

\item{cache}{use a cached version of this training data if available}
}
\description{
Extract text from an image. Requires that you have training data for the language you
are reading. Works best for images with high contrast, little noise and horizontal text.
}
\details{
Tesseract uses training data to perform OCR. Most systems default to English
training data. To improve OCR performance for other langauges you can to install the
training data from your distribution. For example to install the spanish training data:
\itemize{
\item \href{https://packages.debian.org/testing/tesseract-ocr-spa}{tesseract-ocr-spa} (Debian, Ubuntu)
\item \href{https://apps.fedoraproject.org/packages/tesseract-langpack-spa}{tesseract-langpack-spa} (Fedora, EPEL)
}

On other platforms you can manually download training data from \href{https://github.com/tesseract-ocr/tessdata}{github}
and store it in a path on disk that you pass in the \code{datapath} parameter. Alternatively
you can set a default path via the \code{TESSDATA_PREFIX} environment variable.
}
\examples{
# Simple example
text <- ocr("http://jeroenooms.github.io/images/testocr.png")
cat(text)

# Roundtrip test: render PDF to image and OCR it back to text
library(pdftools)
library(tiff)

# A PDF file with some text
setwd(tempdir())
news <- file.path(Sys.getenv("R_DOC_DIR"), "NEWS.pdf")
orig <- pdf_text(news)[1]

# Render pdf to jpeg/tiff image
bitmap <- pdf_render_page(news, dpi = 300)
tiff::writeTIFF(bitmap, "page.tiff")

# Extract text from images
out <- ocr("page.tiff")
cat(out)
}
\references{
\href{https://github.com/tesseract-ocr/tessdata}{Tesseract training data}
}

