% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_rasters.R
\name{merge_rasters}
\alias{merge_rasters}
\title{Merge multiple raster files into a single raster}
\usage{
merge_rasters(
  input_rasters,
  output_raster = tempfile(fileext = ".tif"),
  options = character(0),
  overwrite = FALSE,
  force_fallback = FALSE
)
}
\arguments{
\item{input_rasters}{A character vector containing the file paths to the
georeferenced rasters you want to use.}

\item{output_raster}{The file path to save the merged georeferenced raster
to.}

\item{options}{Optionally, a character vector of options to be passed
directly to \link[sf:gdal_utils]{sf::gdal_utils}. If the fallback is used and any options (other
than "-overwrite") are specified, this will issue a warning.}

\item{overwrite}{Logical: overwrite \code{output_raster} if it exists? If FALSE
and the file exists, this function will fail with an error. The behavior if
this argument is TRUE and "-overwrite" is passed to \code{options} directly is
not stable.}

\item{force_fallback}{Logical: if TRUE, uses the much slower fallback method
by default. This is used for testing purposes and is not recommended for use
by end users.}
}
\value{
\code{output_raster}, invisibly.
}
\description{
Some functions like \link{get_tiles} return multiple separate files
when it can be useful to have a single larger raster instead. This function
is a thin wrapper over \link[sf:gdal_utils]{sf::gdal_utils}, making it easy to
collapse those multiple raster files into a single TIFF.
}
\examples{
\dontrun{
simulated_data <- data.frame(
  lat = c(44.10379, 44.17573),
  lng = c(-74.01177, -73.91171)
)

simulated_data <- sf::st_as_sf(simulated_data, coords = c("lng", "lat"))

img_files <- get_tiles(simulated_data)
merge_rasters(img_files[[1]])
}

}
\seealso{
Other data manipulation functions: 
\code{\link{combine_overlays}()},
\code{\link{georeference_overlay}()},
\code{\link{raster_to_raw_tiles}()},
\code{\link{vector_to_overlay}()}
}
\concept{data manipulation functions}
