% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tiles.R
\name{get_tiles}
\alias{get_tiles}
\alias{get_tiles.sf}
\alias{get_tiles.sfc}
\alias{get_tiles.Raster}
\alias{get_tiles.list}
\title{A user-friendly way to get USGS National Map data tiles for an area}
\usage{
get_tiles(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  ...
)

\method{get_tiles}{sf}(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  ...
)

\method{get_tiles}{sfc}(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  ...
)

\method{get_tiles}{Raster}(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  ...
)

\method{get_tiles}{list}(
  data,
  output_prefix = tempfile(),
  side_length = NULL,
  resolution = 1,
  services = "elevation",
  verbose = FALSE,
  georeference = TRUE,
  ...
)
}
\arguments{
\item{data}{An `sf` or `Raster` object; tiles will be downloaded for the full
extent of the provided object.}

\item{output_prefix}{The file prefix to use when saving tiles.}

\item{side_length}{The length, in meters, of each side of tiles to download.
If \code{NULL}, defaults to the maximum side length permitted by the least
permissive service requested.}

\item{resolution}{How many meters are represented by each pixel? The default
value of 1 means that 1 pixel = 1 meter, while a value of 2 means that
1 pixel = 2 meters, and so on.}

\item{services}{A character vector of services to download data from. Current
options include "3DEPElevation", "USGSNAIPPlus", and "nhd". Users can also
use short codes to download a specific type of data without specifying the
source; current options for short codes include "elevation" (equivalent to
"3DEPElevation"), "ortho" (equivalent to "USGSNAIPPlus), and "hydro" ("nhd").
Short codes are
not guaranteed to refer to the same source across releases. Short codes are
converted to their service name and then duplicates are removed, so any given
source will only be queried once per tile.}

\item{verbose}{Logical: should tile retrieval functions run in verbose mode?}

\item{georeference}{Logical: should tiles be downloaded as PNGs without
georeferencing, or should they be downloaded as georeferenced TIFF files?
This option does nothing when only elevation data is being downloaded.}

\item{...}{Additional arguments passed to [hit_national_map_api].
These can be used to change default query parameters or as additional options
for the National Map services. See below for more details.}
}
\value{
A list of the same length as the number of unique services requested,
containing named vectors of where data files were saved to. Returned
invisibly.
}
\description{
This function splits the area contained within a bounding box into a set of
tiles, and retrieves data from the USGS National map for each tile.
}
\section{Available Datasources}{

The following services are currently available
(with short codes in parentheses where applicable). See links for API
documentation.

* [3DEPElevation](https://elevation.nationalmap.gov/arcgis/rest/services/3DEPElevation/ImageServer)
  (short code: elevation)
* [USGSNAIPPlus](https://services.nationalmap.gov/arcgis/rest/services/USGSNAIPPlus/MapServer)
  (short code: ortho)
* [nhd](https://hydro.nationalmap.gov/arcgis/rest/services/nhd/MapServer)
  (short code: hydro)
* [govunits](https://carto.nationalmap.gov/arcgis/rest/services/govunits/MapServer)
* [contours](https://carto.nationalmap.gov/arcgis/rest/services/contours/MapServer)
* [geonames](https://carto.nationalmap.gov/arcgis/rest/services/geonames/MapServer)
* [NHDPlus_HR](https://hydro.nationalmap.gov/arcgis/rest/services/NHDPlus_HR/MapServer)
* [structures](https://carto.nationalmap.gov/arcgis/rest/services/structures/MapServer)
* [transportation](https://carto.nationalmap.gov/arcgis/rest/services/transportation/MapServer)
* [wbd](https://hydro.nationalmap.gov/arcgis/rest/services/wbd/MapServer)
  ("short code": watersheds)
}

\section{Additional Arguments}{

The `...` argument can be used to pass additional arguments to the
National Map API or to edit the hard-coded defaults used by this function.
More information on common arguments to change can be found in
[hit_national_map_api]. Note that `...` can also be used to change
the formats returned by the server, but that doing so while using this
function will likely cause the function to error (or corrupt the output
data). To download files in different formats, use [hit_national_map_api].
}

\examples{
\dontrun{
simulated_data <- data.frame(
  id = seq(1, 100, 1),
  lat = runif(100, 44.04905, 44.17609),
  lng = runif(100, -74.01188, -73.83493)
)

simulated_data <- sf::st_as_sf(simulated_data, coords = c("lng", "lat"))

get_tiles(simulated_data, tempfile())
}

}
\seealso{
Other data retrieval functions: 
\code{\link{hit_national_map_api}()}
}
\concept{data retrieval functions}
