% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_num_patients.R
\name{summarize_num_patients}
\alias{summarize_num_patients}
\alias{s_num_patients}
\alias{s_num_patients_content}
\alias{analyze_num_patients}
\title{Number of Patients}
\usage{
s_num_patients(
  x,
  labelstr,
  .N_col,
  count_by = NULL,
  unique_count_suffix = TRUE
)

s_num_patients_content(
  df,
  labelstr = "",
  .N_col,
  .var,
  required = NULL,
  count_by = NULL,
  unique_count_suffix = TRUE
)

summarize_num_patients(
  lyt,
  var,
  .stats = NULL,
  .formats = NULL,
  .labels = c(unique = "Number of patients with at least one event", nonunique =
    "Number of events"),
  indent_mod = lifecycle::deprecated(),
  .indent_mods = 0L,
  riskdiff = FALSE,
  ...
)

analyze_num_patients(
  lyt,
  vars,
  nested = TRUE,
  .stats = NULL,
  .formats = NULL,
  .labels = c(unique = "Number of patients with at least one event", nonunique =
    "Number of events"),
  show_labels = c("default", "visible", "hidden"),
  indent_mod = lifecycle::deprecated(),
  .indent_mods = 0L,
  riskdiff = FALSE,
  ...
)
}
\arguments{
\item{x}{(\code{character} or \code{factor})\cr vector of patient IDs.}

\item{labelstr}{(\code{character})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.N_col}{(\code{integer})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{count_by}{(\code{character} or \code{factor})\cr optional vector to be combined with \code{x} when counting
\code{nonunique} records.}

\item{unique_count_suffix}{(\code{logical})\cr should \code{"(n)"} suffix be added to \code{unique_count} labels.
Defaults to \code{TRUE}.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var, var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{required}{(\code{character} or \code{NULL})\cr optional name of a variable that is required to be non-missing.}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{indent_mod}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{.indent_mods} argument instead.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{riskdiff}{(\code{flag})\cr whether a risk difference column is present. When set to \code{TRUE}, \code{\link[=add_riskdiff]{add_riskdiff()}} must be
used as \code{split_fun} in the prior column split of the table layout, specifying which columns should be compared.
See \code{\link[=stat_propdiff_ci]{stat_propdiff_ci()}} for details on risk difference calculation.}

\item{...}{additional arguments for the lower level functions.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure \emph{if
possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}
}
\value{
\itemize{
\item \code{s_num_patients()} returns a named \code{list} of 3 statistics:
\itemize{
\item \code{unique}: Vector of counts and percentages.
\item \code{nonunique}: Vector of counts.
\item \code{unique_count}: Counts.
}
}

\itemize{
\item \code{s_num_patients_content()} returns the same values as \code{s_num_patients()}.
}

\itemize{
\item \code{summarize_num_patients()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_num_patients_content()} to the table layout.
}

\itemize{
\item \code{analyze_num_patients()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_num_patients_content()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Count the number of unique and non-unique patients in a column (variable).
}
\details{
In general, functions that starts with \verb{analyze*} are expected to
work like \code{\link[rtables:analyze]{rtables::analyze()}}, while functions that starts with \verb{summarize*}
are based upon \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}. The latter provides a
value for each dividing split in the row and column space, but, being it
bound to the fundamental splits, it is repeated by design in every page
when pagination is involved.
}
\section{Functions}{
\itemize{
\item \code{s_num_patients()}: Statistics function which counts the number of
unique patients, the corresponding percentage taken with respect to the
total number of patients, and the number of non-unique patients.

\item \code{s_num_patients_content()}: Statistics function which counts the number of unique patients
in a column (variable), the corresponding percentage taken with respect to the total number of
patients, and the number of non-unique patients in the column.

\item \code{summarize_num_patients()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}.

\item \code{analyze_num_patients()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\note{
As opposed to \code{\link[=summarize_num_patients]{summarize_num_patients()}}, this function does not repeat the produced rows.
}
\examples{
# Use the statistics function to count number of unique and nonunique patients.
s_num_patients(x = as.character(c(1, 1, 1, 2, 4, NA)), labelstr = "", .N_col = 6L)
s_num_patients(
  x = as.character(c(1, 1, 1, 2, 4, NA)),
  labelstr = "",
  .N_col = 6L,
  count_by = as.character(c(1, 1, 2, 1, 1, 1))
)

# Count number of unique and non-unique patients.
df <- data.frame(
  USUBJID = as.character(c(1, 2, 1, 4, NA)),
  EVENT = as.character(c(10, 15, 10, 17, 8))
)
s_num_patients_content(df, .N_col = 5, .var = "USUBJID")

df_by_event <- data.frame(
  USUBJID = as.character(c(1, 2, 1, 4, NA)),
  EVENT = as.character(c(10, 15, 10, 17, 8))
)
s_num_patients_content(df_by_event, .N_col = 5, .var = "USUBJID")
s_num_patients_content(df_by_event, .N_col = 5, .var = "USUBJID", count_by = "EVENT")

df_tmp <- data.frame(
  USUBJID = as.character(c(1, 2, 1, 4, NA, 6, 6, 8, 9)),
  ARM = c("A", "A", "A", "A", "A", "B", "B", "B", "B"),
  AGE = c(10, 15, 10, 17, 8, 11, 11, 19, 17)
)
tbl <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  analyze_num_patients("USUBJID", .stats = c("unique")) \%>\%
  build_table(df_tmp)
tbl

}
