% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan_meier_plot.R
\name{h_tbl_coxph_pairwise}
\alias{h_tbl_coxph_pairwise}
\title{Helper Function: Pairwise \code{CoxPH} table}
\usage{
h_tbl_coxph_pairwise(df, variables, control_coxph_pw = control_coxph())
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{variables}{(named \code{list})\cr variable names. Details are:
\itemize{
\item \code{tte} (\code{numeric})\cr variable indicating time-to-event duration values.
\item \code{is_event} (\code{logical})\cr event variable. \code{TRUE} if event, \code{FALSE} if time to event is censored.
\item \code{arm} (\code{factor})\cr the treatment group variable.
\item \code{strat} (\code{character} or \code{NULL})\cr variable names indicating stratification factors.
}}

\item{control_coxph_pw}{(\code{list})\cr parameters for comparison details, specified by using
the helper function \code{\link[=control_coxph]{control_coxph()}}. Some possible parameter options are:
\itemize{
\item \code{pval_method} (\code{string})\cr p-value method for testing hazard ratio = 1.
Default method is \code{"log-rank"}, can also be set to \code{"wald"} or \code{"likelihood"}.
\item \code{ties} (\code{string})\cr method for tie handling. Default is \code{"efron"},
can also be set to \code{"breslow"} or \code{"exact"}. See more in \code{\link[survival:coxph]{survival::coxph()}}
\item \code{conf_level} (\code{proportion})\cr confidence level of the interval for HR.
}}
}
\value{
A \code{data.frame} containing statistics \code{HR}, \verb{XX\% CI} (\code{XX} taken from \code{control_coxph_pw}),
and \code{p-value (log-rank)}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Create a \code{data.frame} of pairwise stratified or unstratified \code{CoxPH} analysis results.
}
\examples{
\donttest{
library(dplyr)

adtte <- tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  mutate(is_event = CNSR == 0)

h_tbl_coxph_pairwise(
  df = adtte,
  variables = list(tte = "AVAL", is_event = "is_event", arm = "ARM"),
  control_coxph_pw = control_coxph(conf_level = 0.9)
)
}

}
