% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abnormal.R
\name{abnormal}
\alias{abnormal}
\alias{s_count_abnormal}
\alias{a_count_abnormal}
\alias{count_abnormal}
\title{Patient Counts with Abnormal Range Values}
\usage{
s_count_abnormal(
  df,
  .var,
  abnormal = list(Low = "LOW", High = "HIGH"),
  variables = list(id = "USUBJID", baseline = "BNRIND"),
  exclude_base_abn = FALSE
)

a_count_abnormal(
  df,
  .var,
  abnormal = list(Low = "LOW", High = "HIGH"),
  variables = list(id = "USUBJID", baseline = "BNRIND"),
  exclude_base_abn = FALSE
)

count_abnormal(
  lyt,
  var,
  nested = TRUE,
  ...,
  table_names = var,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var, var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{abnormal}{(named \code{list})\cr list identifying the abnormal range level(s) in \code{var}. Defaults to
\code{list(Low = "LOW", High = "HIGH")} but you can also group different levels into the named list,
for example, \code{abnormal = list(Low = c("LOW", "LOW LOW"), High = c("HIGH", "HIGH HIGH"))}.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{exclude_base_abn}{(\code{flag})\cr whether to exclude subjects with baseline abnormality
from numerator and denominator.}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure \emph{if
possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
\itemize{
\item \code{s_count_abnormal()} returns the statistic \code{fraction} which is a vector with \code{num} and \code{denom} counts of patients.
}

\itemize{
\item \code{a_count_abnormal()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{count_abnormal()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_abnormal()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Primary analysis variable \code{.var} indicates the abnormal range result (\code{character} or \code{factor})
and additional analysis variables are \code{id} (\code{character} or \code{factor}) and \code{baseline} (\code{character} or
\code{factor}). For each direction specified in \code{abnormal} (e.g. high or low) count patients in the
numerator and denominator as follows:
\itemize{
\item \code{num} : The number of patients with this abnormality recorded while on treatment.
\item \code{denom}: The number of patients with at least one post-baseline assessment.
}
}
\section{Functions}{
\itemize{
\item \code{s_count_abnormal()}: Statistics function which counts patients with abnormal range values
for a single \code{abnormal} level.

\item \code{a_count_abnormal()}: Formatted analysis function which is used as \code{afun} in \code{count_abnormal()}.

\item \code{count_abnormal()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\note{
\itemize{
\item \code{count_abnormal()} only works with a single variable containing multiple abnormal levels.
\item \code{df} should be filtered to include only post-baseline records.
\item the denominator includes patients that might have other abnormal levels at baseline,
and patients with missing baseline. Patients with these abnormalities at
baseline can be optionally excluded from numerator and denominator.
}
}
\examples{
library(dplyr)

df <- data.frame(
  USUBJID = as.character(c(1, 1, 2, 2)),
  ANRIND = factor(c("NORMAL", "LOW", "HIGH", "HIGH")),
  BNRIND = factor(c("NORMAL", "NORMAL", "HIGH", "HIGH")),
  ONTRTFL = c("", "Y", "", "Y"),
  stringsAsFactors = FALSE
)

# Select only post-baseline records.
df <- df \%>\%
  filter(ONTRTFL == "Y")
# Layout creating function.
basic_table() \%>\%
  count_abnormal(var = "ANRIND", abnormal = list(high = "HIGH", low = "LOW")) \%>\%
  build_table(df)

# Passing of statistics function and formatting arguments.
df2 <- data.frame(
  ID = as.character(c(1, 1, 2, 2)),
  RANGE = factor(c("NORMAL", "LOW", "HIGH", "HIGH")),
  BL_RANGE = factor(c("NORMAL", "NORMAL", "HIGH", "HIGH")),
  ONTRTFL = c("", "Y", "", "Y"),
  stringsAsFactors = FALSE
)

# Select only post-baseline records.
df2 <- df2 \%>\%
  filter(ONTRTFL == "Y")

basic_table() \%>\%
  count_abnormal(
    var = "RANGE",
    abnormal = list(low = "LOW", high = "HIGH"),
    variables = list(id = "ID", baseline = "BL_RANGE")
  ) \%>\%
  build_table(df2)

}
\keyword{internal}
