% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance_plot.R
\name{g_covariance}
\alias{g_covariance}
\title{Visualization of Covariance Matrix}
\usage{
g_covariance(
  vcov_matrix,
  time_prefix = NULL,
  x_var = c("lag", "time_diff"),
  xlab = NULL,
  ylab = ""
)
}
\arguments{
\item{vcov_matrix}{(\code{matrix})\cr symmetric covariance matrix with identical
row and column names.}

\item{time_prefix}{(\code{string})\cr string in the names of \code{vcov_matrix} that
precedes the time point value.}

\item{x_var}{(\code{string})\cr can be \code{lag} or \code{time_diff} for lag
or time difference, respectively.}

\item{xlab}{(\code{string} or \code{NULL})\cr x-axis label, if \code{NULL} then automatically
determined from \code{x_var}.}

\item{ylab}{(\code{string})\cr y-axis label.}
}
\value{
The \code{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Plot of covariance (or correlation) matrix as a function of lag or time.
The covariance structure is vectorized internally and lag or time distances
are computed and can be used for visualization.
}
\details{
The default \code{time_prefix} value is \code{NULL}, which assumes that the names
of the input matrix don't have any character string other than time point
value. If a \code{time_prefix} is specified, this string should appear in front of
all the names in \code{vcov_matrix}.
}
\examples{
vcov_matrix <- matrix(
  c(49, 12, 12, 23),
  nrow = 2, ncol = 2,
  dimnames = list(
    c(1, 2),
    c(1, 2)
  )
)
g_covariance(vcov_matrix, x_var = "time_diff")
}
