% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-pars.R
\name{set_pars.term}
\alias{set_pars.term}
\title{Set Parameter Names}
\usage{
\method{set_pars}{term}(x, value, ...)
}
\arguments{
\item{x}{An object.}

\item{value}{A character vector of the new parameter names.}

\item{...}{Other arguments passed to methods.}
}
\value{
The modified object.
}
\description{
Sets an object's parameter names.

The assignment version \verb{pars<-()} forwards to \code{set_pars()}.
}
\details{
\code{value} must be a unique character vector of the same length as the
object's parameters.
}
\examples{
term <- as_term(c("b[2]", "a[1]", "b[3,3]"))
set_pars(term, c("x", "y"))
}
\seealso{
Other parameters: 
\code{\link[universals]{npars}()},
\code{\link[universals]{pars}()}
}
