% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-cast.R
\name{vec_cast.term}
\alias{vec_cast.term}
\title{Cast a vector to a specified type}
\usage{
\method{vec_cast}{term}(x, to, ...)
}
\arguments{
\item{x}{Vectors to cast.}

\item{to}{Type to cast to. If \code{NULL}, \code{x} will be returned as is.}

\item{...}{For \code{vec_cast_common()}, vectors to cast. For
\code{vec_cast()}, \code{vec_cast_default()}, and \code{vec_restore()}, these
dots are only for future extensions and should be empty.}
}
\description{
\code{vec_cast()} provides directional conversions from one type of
vector to another. Along with \code{\link[vctrs:vec_ptype2]{vec_ptype2()}}, this generic forms
the foundation of type coercions in vctrs.
}
\examples{
vec_cast(new_term(c("a[1]", "a[2]")), character())
vec_cast(c("a[1]", "a[2]"), new_term())
}
\seealso{
\code{\link[vctrs:vec_cast]{vctrs::vec_cast()}}
}
