% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempoInput.R
\name{loadGMT}
\alias{loadGMT}
\title{Load a Gene Matrix Transposed formatted file}
\usage{
loadGMT(target)
}
\arguments{
\item{target}{a string indicating the location of the .gmt file}
}
\value{
a list indexed by gene set name of lists of gene ids
}
\description{
\code{loadGMT} loads a Gene Matrix Transposed formatted file from a text file to the data structure used by TEMPO.  In the
.gmt format, each row represents a gene set, with tab delimited columns.  The first column is a gene set name,
the second columns and optional description, and the remaining columns contain gene ids for each gene in the
gene set.  The format is also described at
\href{http://www.broadinstitute.org/cancer/software/gsea/wiki/index.php/Data_formats}{the BROAD site}.
}
\examples{
# An example collection of gene sets is included in the package in .gmt format
exampleGeneSetsPath = file.path(path.package("tempoR"),"dflatExample.gmt")
exampleGeneSets = loadGMT(exampleGeneSetsPath)
}
