% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{results}
\alias{results}
\alias{results.default}
\alias{results.character}
\alias{results.t2d_res}
\alias{results.t2d}
\alias{print.t2d_res}
\title{Results  object}
\usage{
results(x, ...)

\method{results}{default}(x = NULL, fname = "results.slf", ...)

\method{results}{character}(x, fname = NULL, log = NULL, ...)

\method{results}{t2d_res}(x, fname = NULL, log = NULL, ...)

\method{results}{t2d}(x, ...)

\method{print}{t2d_res}(x, ..., n = 10)
}
\arguments{
\item{x}{Either: \code{NULL} (default), in which case a simple template without data will be generated;
a \code{character} string providing the name of an existing results file;
an object of class \code{t2d_res} (modify attributes);
an object of class \code{t2d} (read data after model run).}

\item{...}{Arguments passed to or from other methods, e.g. to \code{\link{read_results}}
such as arguments \code{vars}, \code{times}, or \code{return_datetime}.}

\item{fname}{\code{character}, name for the associated results file (can also be used to replace an existing entry).}

\item{log}{File name of a log file from a simulation run, if it exists.}

\item{n}{Maximum number of steering parameters to print.}
}
\value{
An object of class \code{t2d_res} consisting of an attribute \code{file}
pointing to a specific results file, an attribute \code{log} pointing to the log
of a simulation run, and a \code{list} with elements
\describe{
  \item{header}{General information including title, precision (of numbers in
    the slf file in bytes), the numbers of mesh elements and points, the number
    of points per mesh (3 in case of triangles which is the only supported value for now),
    the variable names and units, and the simulation start date.}
  \item{tin}{An object of class \code{t2d_tin} representing the underlying mesh.}
  \item{log}{The log messages (a \code{character} vector).}
  \item{values}{A \code{data.frame} where each line represents the value for a
    certain mesh point (with coordinates x and y) at a certain simulation timestep (note
    that this might be difficult to interpret if you used variable timestep lengths) for a
    specific variable.}
}
}
\description{
Initialise a results object to handle the results of TELEMAC-2D runs.
}
\note{
Also note the associated \code{\link{plot.t2d_res}} method.
}
