% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selafin.R
\name{read_slf_variable}
\alias{read_slf_variable}
\title{Read slf variables}
\usage{
read_slf_variable(fname, seek_start, vars, nv, fsize, npoin, times = NULL)
}
\arguments{
\item{fname}{\code{character}, name of a SELAFIN file.}

\item{seek_start}{\code{integer}, starting position to read data from the binary
file; can be inferred with function \code{\link{read_slf_header}}.}

\item{vars}{\code{numeric}, vector giving the indices of the variables that shall
be read (can be inferred from header information, \code{\link{read_slf_header}}).}

\item{nv}{\code{integer} giving the total number of variables in the file.}

\item{fsize}{\code{integer}, precision of the values (number of bytes).}

\item{npoin}{\code{integer}, number of mesh points.}

\item{times}{\code{integer} vector, the timesteps to be read. If any specified
timestep cannot be found in the file an error is raised. Default (\code{NULL}): all.}
}
\value{
A \code{list} with the following elements:
\describe{
  \item{time}{Timesteps in seconds relative to \code{date} (element in output of \code{\link{read_slf_header}})}
  \item{values}{An array of dimensions \code{(npoin x nv x length(time))} with the values of the variables for each meshpoint and timestep}
}
}
\description{
Reads the variables stored in a SELAFIN file (*.slf).
}
