% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{Webhook}
\alias{Webhook}
\alias{is.Webhook}
\title{Building a Telegram Bot with a Webhook}
\format{
An \code{\link{R6Class}} object.
}
\usage{
Webhook(
  webhook_url,
  token = NULL,
  base_url = NULL,
  base_file_url = NULL,
  request_config = NULL,
  certificate = NULL,
  max_connections = NULL,
  allowed_updates = NULL,
  ip_address = NULL,
  drop_pending_updates = FALSE,
  verbose = FALSE,
  bot = NULL
)

is.Webhook(x)
}
\arguments{
\item{webhook_url}{Webhook HTTPS url to send updates to. The url is conventionally
    suffixed with the \code{/webhook} path.

    \strong{Note}: The url must be publicly accessible, since Telegram will need to make
    HTTP \code{POST} requests to the end-point for each update.

    For example, if you are deploying to Heroku, you can use the app's hostname,
    such as \code{https://[name of app].herokuapp.com/webhook}, or a
    \href{https://devcenter.heroku.com/articles/custom-domains}{custom hostname}
    for a domain that belongs to you, such as \code{https://app.yourcustomdomain.com/webhook}.}

\item{token}{(Optional). The bot's token given by the \emph{BotFather}.}

\item{base_url}{(Optional). Telegram Bot API service URL.}

\item{base_file_url}{(Optional). Telegram Bot API file URL.}

\item{request_config}{(Optional). Additional configuration settings
    to be passed to the bot's POST requests. See the \code{config}
    parameter from \code{httr::POST} for further details.

    The \code{request_config} settings are very
    useful for the advanced users who would like to control the
    default timeouts and/or control the proxy used for HTTP communication.}

\item{certificate}{(Optional). Upload your public key certificate so that
the root certificate in use can be checked. See Telegram's
\href{https://core.telegram.org/bots/self-signed}{self-signed guide} for
details.}

\item{max_connections}{(Optional). Maximum allowed number of simultaneous
HTTPS connections to the webhook for update delivery, 1-100. Defaults to
40. Use lower values to limit the load on your bot's server, and higher
values to increase your bot's throughput.}

\item{allowed_updates}{(Optional). String or vector of strings with the
    types of updates you want your bot to receive. For example, specify
    \code{c("message", "edited_channel_post", "callback_query")} to only
    receive updates of these types. See
    \href{https://core.telegram.org/bots/api#update}{Update}
    for a complete list of available update types. Specify an empty string
    to receive all updates regardless of type (default). If not specified,
    the previous setting will be used.

    Please note that this parameter doesn't affect updates created before
    the call to the get_updates, so unwanted updates may be received for a
    short period of time.}

\item{ip_address}{(Optional). The fixed IP address which will be used to
send webhook requests instead of the IP address resolved through DNS.}

\item{drop_pending_updates}{(Optional). Pass True to drop all pending updates.}

\item{verbose}{(Optional). If \code{TRUE}, prints status of the polling.
Default is \code{FALSE}.}

\item{bot}{(Optional). A pre-initialized \code{\link{Bot}} instance.}

\item{x}{Object to be tested.}
}
\description{
This class, which employs the class \code{\link{Dispatcher}}, provides a
front-end to class \code{\link{Bot}} to the programmer, so you can focus on
coding the bot. Its purpose is to receive updates via webhook from Telegram and
to deliver them to said dispatcher. The dispatcher supports
\code{\link{Handler}} classes for different kinds of data: Updates from
Telegram, basic text commands and even arbitrary types. See
\code{\link{add}} (\code{+}) to learn more about building your \code{Webhook}.
}
\details{
You \strong{must} supply the \code{webhook_url} and either a \code{bot}
or a \code{token} argument.

The \code{webhook_url} must be publicly accessible, since Telegram will
need to make HTTP \code{POST} requests to the end-point for each update.

\strong{Security Note}: \code{Webhook} encapsulates generating a \code{secret_token} which
is used to validate that the request comes from a webhook set by you.
}
\section{Methods}{
 \describe{
    \item{\code{\link{start_server}}}{Starts listening for updates from
      Telegram.}
    \item{\code{\link{stop_server}}}{Stops listening for updates.}
    \item{\code{\link{running}}}{Returns \code{TRUE} when listening for updates.}
}
}

\examples{
\dontrun{
webhook <- Webhook("https://example.com/webhook", "TOKEN")

# In case you want to set a proxy
webhook <- Webhook(
  webhook_url = "https://example.com/webhook",
  token = "TOKEN",
  request_config = httr::use_proxy(...),
  verbose = TRUE
)

# Add a handler
start <- function(bot, update) {
  bot$sendMessage(
    chat_id = update$message$chat_id,
    text = sprintf(
      "Hello \%s!",
      update$message$from$first_name
    )
  )
}
webhook <- webhook + CommandHandler("start", start)

# Start polling
webhook$start_server() # Send '/start' to the bot
}
}
\references{
\href{https://core.telegram.org/bots}{Bots: An introduction for developers},
    \href{https://core.telegram.org/bots/api}{Telegram Bot API} and
    \href{https://core.telegram.org/bots/webhooks}{Marvin's Marvellous Guide to All Things Webhook}
}
