% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\docType{data}
\name{MessageFilters}
\alias{MessageFilters}
\title{Filter message updates}
\format{A \code{list} with filtering functions.}
\usage{
MessageFilters
}
\description{
Predefined filters for use as the \code{filter} argument of class \code{\link{MessageHandler}}.
}
\details{
See \code{\link{BaseFilter}} and \code{\link{filtersLogic}} for
advanced filters.
}
\section{Functions}{
 \itemize{
    \item{\code{all}: All Messages.}
    \item{\code{text}: Text Messages.}
    \item{\code{command}: Messages starting with \code{/}.}
    \item{\code{reply}: Messages that are a reply to another message.}
    \item{\code{audio}: Messages that contain audio.}
    \item{\code{document}: Messages that contain document.}
    \item{\code{photo}: Messages that contain photo.}
    \item{\code{sticker}: Messages that contain sticker.}
    \item{\code{video}: Messages that contain video.}
    \item{\code{voice}: Messages that contain voice.}
    \item{\code{contact}: Messages that contain contact.}
    \item{\code{location}: Messages that contain location.}
    \item{\code{venue}: Messages that are forwarded.}
    \item{\code{game}: Messages that contain game.}
}
}

\examples{
\dontrun{
# Use to filter all video messages
video_handler <- MessageHandler(callback_method, MessageFilters$video)

# To filter all contacts, etc.
contact_handler <- MessageHandler(callback_method, MessageFilters$contact)
}
}
\keyword{datasets}
