% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseEOFAlpha.R
\name{summariseEOFAlpha}
\alias{summariseEOFAlpha}
\title{Summarize eof-mapped alphas}
\usage{
summariseEOFAlpha(eof_alpha, prob = 0.95, coords.s)
}
\arguments{
\item{eof_alpha}{structure containing posterior inference for transformed 
remote coefficients}

\item{prob}{confidence level for confidence intervals and significance}

\item{coords.s}{matrix with coordinates where responses were 
observed (lon, lat)}
}
\description{
This function computes approximate normal intervals, etc. for fitted 
eof-mapped alphas.
}
\examples{

data("coprecip.predict")
attach(coprecip.predict)

alpha.eof.90 = summariseEOFAlpha(eof_alpha = eof_alpha_knots, prob = .9, 
  coords.s = coords.s)

}
