% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll_statistics.R
\name{rolling_test_dist}
\alias{rolling_test_dist}
\alias{distroll_circstats}
\alias{distroll_confidence}
\alias{distroll_dispersion}
\alias{distroll_dispersion_sde}
\title{Apply Rolling Functions using Circular Statistics}
\usage{
distroll_circstats(
  x,
  distance,
  FUN,
  width = NULL,
  min_n = 2,
  align = c("right", "center", "left"),
  w = NULL,
  sort = TRUE,
  ...
)

distroll_confidence(
  x,
  distance,
  w = NULL,
  width = NULL,
  min_n = 2,
  align = c("right", "center", "left"),
  sort = TRUE,
  ...
)

distroll_dispersion(
  x,
  y,
  w = NULL,
  w.y = NULL,
  distance,
  width = NULL,
  min_n = 2,
  align = c("right", "center", "left"),
  sort = TRUE,
  ...
)

distroll_dispersion_sde(
  x,
  y,
  w = NULL,
  w.y = NULL,
  distance,
  width = NULL,
  min_n = 2,
  align = c("right", "center", "left"),
  sort = TRUE,
  ...
)
}
\arguments{
\item{x, y}{vectors of numeric values in degrees. \code{length(y)} is either 1 or
\code{length(x)}}

\item{distance}{numeric. the independent variable along the values in \code{x}
are sorted, e.g. the plate boundary distances}

\item{FUN}{the function to be applied}

\item{width}{numeric. the range across \code{distance} on which \code{FUN} should be
applied on \code{x}. If \code{NULL}, then width is a number that separates the
distances in 10 equal groups.}

\item{min_n}{integer. The minimum values that should be considered in \code{FUN}
(2 by default), otherwise \code{NA}.}

\item{align}{specifies whether the index of the result should be left- or
right-aligned or centered (default) compared to the rolling window of
observations. This argument is only used if width represents widths.}

\item{w}{numeric. the weighting for \code{x}}

\item{sort}{logical. Should the values be sorted after \code{distance} prior to
applying the function (\code{TRUE} by default).}

\item{...}{optional arguments to \code{FUN}}

\item{w.y}{numeric. the weighting for \code{y}}
}
\value{
two-column vectors of (sorted) \code{x} and the rolled statistics along
\code{distance}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
A generic function for applying a function to rolling margins of an array
along an additional value.
}
\note{
\code{distroll_circstats()} and friends are complete, and for new code it is
recommended switching to \code{\link[=distance_binned_stats]{distance_binned_stats()}},
which is fasrter, easier to use, more featureful, and still under active development.
}
\examples{
data("plates")
plate_boundary <- subset(plates, plates$pair == "na-pa")
data("san_andreas")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
san_andreas$distance <- distance_from_pb(
  x = san_andreas,
  PoR = PoR,
  pb = plate_boundary,
  tangential = TRUE
)
dat <- san_andreas |> cbind(PoR_shmax(san_andreas, PoR, "right"))

distroll_circstats(dat$azi.PoR,
  distance = dat$distance,
  w = 1 / dat$unc, FUN = circular_mean
) |> head()
distroll_confidence(dat$azi.PoR, distance = dat$distance, w = 1 / dat$unc) |> head()
distroll_dispersion(dat$azi.PoR,
  y = 135,
  distance = dat$distance, w = 1 / dat$unc
) |> head()
distroll_dispersion_sde(dat$azi.PoR,
  y = 135,
  distance = dat$distance, w = 1 / dat$unc, R = 100
) |> head()

# New functions
distance_binned_stats(
  dat$azi.PoR,
  distance = dat$distance, width.breaks = 1, unc = dat$unc, prd = 135
) |> head()
}
\keyword{internal}
