% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tleaves.R
\name{E}
\alias{E}
\title{Evaporation (mol / (m^2 s))}
\usage{
E(T_leaf, pars, unitless)
}
\arguments{
\item{T_leaf}{Leaf temperature in Kelvin}

\item{pars}{Concatenated parameters (\code{leaf_par}, \code{enviro_par}, and \code{constants})}

\item{unitless}{Logical. Should function use parameters with \code{units}? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
\code{unitless = TRUE}: A value in units of mol / (m ^ 2 / s) number of class \code{numeric} 
\code{unitless = FALSE}: A value in units of mol / (m ^ 2 / s) of class \code{units}
}
\description{
Evaporation (mol / (m^2 s))
}
\details{
The leaf evaporation rate is the product of the total conductance to water vapour (m / s) and the water vapour gradient (mol / m^3):

\deqn{E = g_\mathrm{tw} D_\mathrm{wv}}{E = g_tw D_wv}

If \code{unitless = TRUE}, \code{T_leaf} is assumed in degrees K without checking.
}
\examples{

library(tealeaves)

cs <- make_constants()
ep <- make_enviropar()
lp <- make_leafpar()

T_leaf <- set_units(298.15, K)

E(T_leaf, c(cs, ep, lp), FALSE)

}
