% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_transform_data.R
\name{module_transform_data}
\alias{module_transform_data}
\alias{ui_transform_teal_data}
\alias{srv_transform_teal_data}
\title{Module to transform \code{reactive} \code{teal_data}}
\usage{
ui_transform_teal_data(id, transformators, class = "well")

srv_transform_teal_data(
  id,
  data,
  transformators,
  modules = NULL,
  is_transform_failed = reactiveValues()
)
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{class}{(character(1)) CSS class to be added in the \code{div} wrapper tag.}

\item{data}{(\code{reactive} returning \code{teal_data})}

\item{modules}{(\code{teal_modules} or \code{teal_module}) For \code{datanames} validation purpose}

\item{is_transform_failed}{(\code{reactiveValues}) contains \code{logical} flags named after each transformator.
Help to determine if any previous transformator failed, so that following transformators can be disabled
and display a generic failure message.}
}
\value{
\code{reactive} \code{teal_data}
}
\description{
Module calls \code{\link[=teal_transform_module]{teal_transform_module()}} in sequence so that \verb{reactive teal_data} output
from one module is handed over to the following module's input.
}
