% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_tabs_with_filters.R
\name{module_tabs_with_filters}
\alias{module_tabs_with_filters}
\alias{ui_tabs_with_filters}
\alias{srv_tabs_with_filters}
\title{Add right filter panel into each of the top-level \code{teal_modules} UIs}
\usage{
ui_tabs_with_filters(id, modules, datasets, filter = teal_slices())

srv_tabs_with_filters(
  id,
  datasets,
  modules,
  reporter = teal.reporter::Reporter$new(),
  filter = teal_slices()
)
}
\arguments{
\item{id}{(\code{character(1)})
module id}

\item{modules}{(\code{teal_modules}) object containing the output modules which
will be displayed in the \code{teal} application. See \code{\link[=modules]{modules()}} and \code{\link[=module]{module()}} for
more details.}

\item{datasets}{(named \code{list} of \code{FilteredData})
object to store filter state and filtered datasets, shared across modules. For more
details see \code{\link[teal.slice:FilteredData]{teal.slice::FilteredData}}. Structure of the list must be the same as structure
of the \code{modules} argument and list names must correspond to the labels in \code{modules}.
When filter is not module-specific then list contains the same object in all elements.}

\item{filter}{(\code{teal_slices})
Specifies the initial filter using \code{\link[=teal_slices]{teal_slices()}}.}

\item{reporter}{(\code{Reporter}) object from \code{teal.reporter}}
}
\value{
A \code{shiny.tag.list} containing the main menu, placeholders for filters and placeholders for the \code{teal} modules.
}
\description{
The \link{ui_nested_tabs} function returns a nested tabbed UI corresponding
to the nested modules.
This function adds the right filter panel to each main tab.
}
\details{
The right filter panel's filter choices affect the \code{datasets} object. Therefore,
all modules using the same \code{datasets} share the same filters.

This works with nested modules of depth greater than 2, though the filter
panel is inserted at the right of the modules at depth 1 and not at the leaves.
}
\keyword{internal}
