% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_variable_browser.R
\name{tm_variable_browser}
\alias{tm_variable_browser}
\title{\code{teal} module: Variable browser}
\usage{
tm_variable_browser(
  label = "Variable Browser",
  datasets_selected = character(0),
  parent_dataname = "ADSL",
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args()
)
}
\arguments{
\item{label}{(\code{character(1)}) Label shown in the navigation item for the module or module group.
For \code{modules()} defaults to \code{"root"}. See \code{Details}.}

\item{datasets_selected}{(\code{character}) vector of datasets which should be
shown, in order. Names must correspond with datasets names.
If vector of length zero (default) then all datasets are shown.
Note: Only \code{data.frame} objects are compatible; using other types will cause an error.}

\item{parent_dataname}{(\code{character(1)}) string specifying a parent dataset.
If it exists in \code{datasets_selected}then an extra checkbox will be shown to
allow users to not show variables in other datasets which exist in this \code{dataname}.
This is typically used to remove \code{ADSL} columns in \code{CDISC} data.
In non \code{CDISC} data this can be ignored. Defaults to \code{"ADSL"}.}

\item{pre_output}{(\code{shiny.tag}) optional, text or UI element to be displayed before the module's output,
providing context or a title.
with text placed before the output to put the output into context. For example a title.}

\item{post_output}{(\code{shiny.tag}) optional, text or UI element to be displayed after the module's output,
adding context or further instructions. Elements like \code{shiny::helpText()} are useful.}

\item{ggplot2_args}{(\code{ggplot2_args}) object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}}
with settings for the module plot.
The argument is merged with options variable \code{teal.ggplot2_args} and default module setup.

For more details see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}}
}
\value{
Object of class \code{teal_module} to be used in \code{teal} applications.
}
\description{
Module provides provides a detailed summary and visualization of variable distributions
for \code{data.frame} objects, with interactive features to customize analysis.
}
\details{
Numeric columns with fewer than 30 distinct values can be treated as either discrete
or continuous with a checkbox allowing users to switch how they are treated(if < 6 unique values
then the default is discrete, otherwise it is continuous).
}
\examples{
library(teal.widgets)

# Module specification used in apps below
tm_variable_browser_module <- tm_variable_browser(
  label = "Variable browser",
  ggplot2_args = ggplot2_args(
    labs = list(subtitle = "Plot generated by Variable Browser Module")
  )
)

# general data example
data <- teal_data()
data <- within(data, {
  iris <- iris
  mtcars <- mtcars
  women <- women
  faithful <- faithful
  CO2 <- CO2
})
datanames(data) <- c("iris", "mtcars", "women", "faithful", "CO2")

app <- init(
  data = data,
  modules = modules(tm_variable_browser_module)
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

# CDISC example data
data <- teal_data()
data <- within(data, {
  ADSL <- rADSL
  ADTTE <- rADTTE
})
datanames(data) <- c("ADSL", "ADTTE")
join_keys(data) <- default_cdisc_join_keys[datanames(data)]

app <- init(
  data = data,
  modules = modules(tm_variable_browser_module)
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
