% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_pp_adverse_events.R
\name{template_adverse_events}
\alias{template_adverse_events}
\title{Template: Patient Profile Adverse Events Table and Plot}
\usage{
template_adverse_events(
  dataname = "ANL",
  aeterm = "AETERM",
  tox_grade = "AETOXGR",
  causality = "AEREL",
  outcome = "AEOUT",
  action = "AEACN",
  time = "ASTDY",
  decod = NULL,
  patient_id,
  font_size = 12L,
  ggplot2_args = teal.widgets::ggplot2_args()
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{aeterm}{(\code{character})\cr name of the reported term for the adverse event variable.}

\item{tox_grade}{(\code{character})\cr name of the standard toxicity grade variable.}

\item{causality}{(\code{character})\cr name of the causality variable.}

\item{outcome}{(\code{character})\cr name of outcome of adverse event variable.}

\item{action}{(\code{character})\cr name of action taken with study treatment variable.}

\item{time}{(\code{character})\cr name of study day of start of adverse event variable.}

\item{decod}{(\code{character})\cr name of dictionary derived term variable.}

\item{patient_id}{(\code{character})\cr patient ID.}

\item{font_size}{(\code{numeric})\cr font size value.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate an adverse events table and \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot using ADaM datasets.
}
\seealso{
\code{\link[=tm_g_pp_adverse_events]{tm_g_pp_adverse_events()}}
}
\keyword{internal}
