% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_lineplot.R
\name{tm_g_lineplot}
\alias{tm_g_lineplot}
\title{teal Module: Line Plot}
\usage{
tm_g_lineplot(
  label,
  dataname,
  parentname = ifelse(inherits(strata, "data_extract_spec"),
    teal.transform::datanames_input(strata), "ADSL"),
  strata = teal.transform::choices_selected(teal.transform::variable_choices(parentname,
    c("ARM", "ARMCD", "ACTARMCD")), "ARM"),
  x = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AVISIT"), "AVISIT", fixed = TRUE),
  y = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    c("AVAL", "BASE", "CHG", "PCHG")), "AVAL"),
  y_unit = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AVALU"), "AVALU", fixed = TRUE),
  paramcd = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "PARAMCD"), "PARAMCD", fixed = TRUE),
  param = teal.transform::choices_selected(teal.transform::value_choices(dataname,
    "PARAMCD", "PARAM"), "ALT"),
  conf_level = teal.transform::choices_selected(c(0.95, 0.9, 0.8), 0.95, keep_order =
    TRUE),
  interval = "mean_ci",
  mid = "mean",
  whiskers = c("mean_ci_lwr", "mean_ci_upr"),
  table = c("n", "mean_sd", "median", "range"),
  mid_type = "pl",
  mid_point_size = c(2, 1, 5),
  table_font_size = c(4, 2, 6),
  plot_height = c(1000L, 200L, 4000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{strata}{(\code{character} or \code{NA})\cr deprecated - group variable name.}

\item{x}{(\code{character})\cr x variable name.}

\item{y}{(\code{character})\cr y variable name.}

\item{y_unit}{(\code{character} or \code{NA})\cr \code{y_unit} variable name.}

\item{paramcd}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the parameter code variable from \code{dataname}.}

\item{param}{(\code{character})\cr parameter to filter the data by.}

\item{conf_level}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the confidence level, each within range of (0, 1).}

\item{interval}{(\code{character} or \code{NULL})\cr names of the statistics that will be plotted as intervals.
All the statistics indicated in \code{interval} variable must be present in the object returned by \code{sfun},
and be of a \code{double} or \code{numeric} type vector of length two. Set \code{interval = NULL} if intervals should not be
added to the plot.}

\item{mid}{(\code{character} or \code{NULL})\cr names of the statistics that will be plotted as midpoints.
All the statistics indicated in \code{mid} variable must be present in the object returned by \code{sfun},
and be of a \code{double} or \code{numeric} type vector of length one.}

\item{whiskers}{(\code{character})\cr names of the interval whiskers that will be plotted. Names must match names
of the list element \code{interval} that will be returned by \code{sfun} (e.g. \code{mean_ci_lwr} element of
\code{sfun(x)[["mean_ci"]]}). It is possible to specify one whisker only, or to suppress all whiskers by setting
\code{interval = NULL}.}

\item{table}{(\code{character} or \code{NULL})\cr names of the statistics that will be displayed in the table below the plot.
All the statistics indicated in \code{table} variable must be present in the object returned by \code{sfun}.}

\item{mid_type}{(\code{character})\cr controls the type of the \code{mid} plot, it can be point (\code{p}), line (\code{l}),
or point and line (\code{pl}).}

\item{mid_point_size}{(\code{integer} or \code{double})\cr controls the font size of the point for \code{mid} plot.}

\item{table_font_size}{(\code{integer} or \code{double})\cr controls the font size of values in the table.}

\item{plot_height}{optional, (\code{numeric})\cr a vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{optional, (\code{numeric})\cr a vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{optional, (\code{shiny.tag})\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{optional, (\code{shiny.tag})\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{optional, (\code{ggplot2_args})\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. For this module, this argument will only accept \code{ggplot2_args} object with \code{labs} list of
following child elements: \code{title}, \code{subtitle}, \code{caption}, \code{y}, \code{lty}. No other elements would be taken into
account. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments (hard coded in
the module body).

For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} type line plot, with optional summary table, for standard ADaM data.
}
\examples{
library(nestcolor)
library(dplyr)
library(forcats)

ADSL <- tmc_ex_adsl
ADLB <- tmc_ex_adlb \%>\% mutate(AVISIT == fct_reorder(AVISIT, AVISITN, min))

app <- init(
  data = cdisc_data(
    ADSL = ADSL,
    ADLB = ADLB,
    code = "
      ADSL <- tmc_ex_adsl
      ADLB <- tmc_ex_adlb \%>\% mutate(AVISIT == fct_reorder(AVISIT, AVISITN, min))
    "
  ),
  modules = modules(
    tm_g_lineplot(
      label = "Line Plot",
      dataname = "ADLB",
      strata = choices_selected(
        variable_choices(ADSL, c("ARM", "ARMCD", "ACTARMCD")),
        "ARM"
      ),
      y = choices_selected(
        variable_choices(ADLB, c("AVAL", "BASE", "CHG", "PCHG")),
        "AVAL"
      ),
      param = choices_selected(
        value_choices(ADLB, "PARAMCD", "PARAM"),
        "ALT"
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
