% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_km.R
\name{template_g_km}
\alias{template_g_km}
\title{Template: Kaplan-Meier Plot}
\usage{
template_g_km(
  dataname = "ANL",
  arm_var = "ARM",
  ref_arm = NULL,
  comp_arm = NULL,
  compare_arm = FALSE,
  combine_comp_arms = FALSE,
  aval_var = "AVAL",
  cnsr_var = "CNSR",
  xticks = NULL,
  strata_var = NULL,
  time_points = NULL,
  facet_var = "SEX",
  font_size = 10,
  conf_level = 0.95,
  ties = "efron",
  xlab = "Survival time",
  time_unit_var = "AVALU",
  yval = "Survival",
  pval_method = "log-rank",
  annot_surv_med = TRUE,
  annot_coxph = TRUE,
  position_coxph = c(-0.04, 0.02),
  width_annots = list(surv_med = grid::unit(0.45, "npc"), coxph = grid::unit(0.6, "npc")),
  ci_ribbon = FALSE,
  title = "KM Plot"
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{ref_arm}{(\code{character})\cr the level of reference arm in case of arm comparison.}

\item{comp_arm}{(\code{character})\cr the level of comparison arm in case of arm comparison.}

\item{compare_arm}{(\code{logical})\cr triggers the comparison between study arms.}

\item{combine_comp_arms}{(\code{logical})\cr triggers the combination of comparison arms.}

\item{aval_var}{(\code{character})\cr name of the analysis value variable.}

\item{cnsr_var}{(\code{character})\cr name of the censoring variable.}

\item{xticks}{(\code{numeric}, \code{number}, or \code{NULL})\cr numeric vector of ticks or single number with spacing
between ticks on the x axis. If \code{NULL} (default), \code{\link[labeling:extended]{labeling::extended()}} is used to determine
an optimal tick position on the x axis.}

\item{strata_var}{(\code{character})\cr names of the variables for stratified analysis.}

\item{time_points}{(\code{character})\cr time points that can be used in \code{\link[tern:survival_timepoint]{tern::surv_timepoint()}}.}

\item{facet_var}{(\code{character})\cr name of the variable to use to facet the plot.}

\item{font_size}{(\code{numeric})\cr font size value.}

\item{conf_level}{(\code{numeric})\cr value for the confidence level within the range of (0, 1).}

\item{ties}{(\code{string})\cr among \code{exact} (equivalent to \code{DISCRETE} in SAS), \code{efron} and \code{breslow},
see \code{\link[survival:coxph]{survival::coxph()}}. Note: there is no equivalent of SAS \code{EXACT} method in R.}

\item{xlab}{(\code{string})\cr label of x-axis.}

\item{time_unit_var}{(\code{character})\cr name of the variable representing time units.}

\item{yval}{(\code{string})\cr value of y-axis. Options are \code{Survival} (default) and \code{Failure} probability.}

\item{pval_method}{(\code{string})\cr the method used for estimation of p.values; \code{wald} (default) or \code{likelihood}.}

\item{annot_surv_med}{(\code{flag})\cr compute and add the annotation table on the Kaplan-Meier curve estimating the
median survival time per group.}

\item{annot_coxph}{(\code{flag})\cr add the annotation table from a \code{\link[survival:coxph]{survival::coxph()}} model.}

\item{position_coxph}{(\code{numeric})\cr x and y positions for plotting \code{\link[survival:coxph]{survival::coxph()}} model.}

\item{width_annots}{(named \code{list} of \code{unit}s)\cr a named list of widths for annotation tables with names \code{surv_med}
(median survival time table) and \code{coxph} (\code{\link[survival:coxph]{survival::coxph()}} model table), where each value is the width
(in units) to implement when printing the annotation table.}

\item{ci_ribbon}{(\code{flag})\cr draw the confidence interval around the Kaplan-Meier curve.}

\item{title}{(\code{character})\cr title of the output.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a Kaplan-Meier plot.
}
\seealso{
\code{\link[=tm_g_km]{tm_g_km()}}
}
\keyword{internal}
