% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_barchart_simple.R
\name{make_barchart_simple_call}
\alias{make_barchart_simple_call}
\title{\code{ggplot2} call to generate simple bar chart}
\usage{
make_barchart_simple_call(
  y_name,
  x_name = NULL,
  fill_name = NULL,
  x_facet_name = NULL,
  y_facet_name = NULL,
  label_bars = TRUE,
  barlayout = c("side_by_side", "stacked"),
  flip_axis = FALSE,
  rotate_bar_labels = FALSE,
  rotate_x_label = FALSE,
  rotate_y_label = FALSE,
  expand_y_range = 0,
  facet_scales = "free_x",
  ggplot2_args = teal.widgets::ggplot2_args()
)
}
\arguments{
\item{y_name}{(\code{character} or \code{NULL})\cr name of the y-axis variable.}

\item{x_name}{(\code{character} or \code{NULL})\cr name of the x-axis variable. Defaults to \code{NULL} because it is dependent
on extract input which can be empty.}

\item{fill_name}{(\code{character} or \code{NULL})\cr name of the variable to determine the bar fill color.}

\item{x_facet_name}{(\code{character} or \code{NULL})\cr name of the variable to use for horizontal plot faceting.}

\item{y_facet_name}{(\code{character} or \code{NULL})\cr name of the variable to use for vertical plot faceting.}

\item{label_bars}{(\code{logical} or \code{NULL})\cr whether bars should be labeled. If \code{TRUE}, label bar numbers would
also be drawn as text.}

\item{barlayout}{(\code{character} or \code{NULL})\cr type of the bar layout. Options are \code{"stacked"} (default) or
\code{"side_by_side"}.}

\item{flip_axis}{(\code{character} or \code{NULL})\cr whether to flip the plot axis.}

\item{rotate_bar_labels}{(\code{logical} or \code{NULL})\cr whether bar labels should be rotated by 45 degrees.}

\item{rotate_x_label}{(\code{logical} or \code{NULL})\cr whether x-axis labels should be rotated by 45 degrees.}

\item{rotate_y_label}{(\code{logical} or \code{NULL})\cr whether y-axis labels should be rotated by 45 degrees.}

\item{expand_y_range}{(\code{numeric} or \code{NULL})\cr fraction of y-axis range to further expand by.}

\item{facet_scales}{(\code{character})\cr value passed to \code{scales} argument of \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}}. Options are
\code{fixed}, \code{free_x}, \code{free_y}, and \code{free}.}

\item{ggplot2_args}{optional, (\code{ggplot2_args})\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}
}
\value{
\code{call} to produce a \code{ggplot} object.
}
\description{
\code{ggplot2} call to generate simple bar chart
}
\keyword{internal}
