% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-eval_code.R
\name{eval_code}
\alias{eval_code}
\alias{eval_code,qenv,expression-method}
\alias{eval_code,qenv,language-method}
\alias{eval_code,qenv,character-method}
\alias{eval_code,qenv.error,ANY-method}
\title{Evaluate the code in the \code{qenv} environment}
\usage{
eval_code(object, code)

\S4method{eval_code}{qenv,expression}(object, code)

\S4method{eval_code}{qenv,language}(object, code)

\S4method{eval_code}{qenv,character}(object, code)

\S4method{eval_code}{qenv.error,ANY}(object, code)
}
\arguments{
\item{object}{(\code{qenv})}

\item{code}{(\code{character} or \code{language}) code to evaluate. Also accepts and stores comments}
}
\value{
\code{qenv} object.
}
\description{
Given code is evaluated in the \code{qenv} environment and appended to the \code{code} slot. This means
that state of the environment is always a result of the stored code (if \code{qenv} was initialized)
with reproducible code.
}
\examples{
q1 <- new_qenv(env = list2env(list(a = 1)), code = quote(a <- 1))
q2 <- eval_code(q1, quote(library(checkmate)))
q3 <- eval_code(q2, quote(assert_number(a)))

}
