% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_earliest_timestamp.R
\name{ref_earliest_timestamp}
\alias{ref_earliest_timestamp}
\title{Reference Data Accessor for Symbol Search from \sQuote{twelvedata}}
\usage{
ref_earliest_timestamp(
  sym,
  interval = c("1min", "5min", "15min", "30min", "45min", "1h", "2h", "4h", "1day",
    "1week", "1month"),
  as = c("data.frame", "raw"),
  exchange = "",
  timezone = NA_character_,
  apikey
)
}
\arguments{
\item{sym}{(character) A (single or vector) symbol understood by the backend as a stock
symbol, foreign exchange pair, or more. See the \sQuote{twelvedata} documentation for
details on what is covered. In the case of a vector of arguments a list is returned.}

\item{interval}{(character) A valid interval designator ranging form \dQuote{1min} to
\dQuote{1month}. Currently supported are 1, 5, 15, 30 and 45 minutes, 1, 2, 4 hours (using
suffix \sQuote{h}, as well as \dQuote{1day}, \dQuote{1week} and \dQuote{1month}.}

\item{as}{(optional, character) A selector for the desired output format: one of
\dQuote{data.frame} (the default) or or \dQuote{raw}.}

\item{exchange}{(optional, character) A selection of the exchange for which data for
\dQuote{sym} is requested, default value is unset.}

\item{timezone}{(optional, character) The timezone of the returned time stamp. This parameter
is optional. Possible values are \dQuote{Exchange} (the default) to return the
exchange-supplied value, \dQuote{UTC} to use UTC, or a value IANA timezone name such as
\dQuote{America/New_York} (see \code{link{OlsonNames}} to see the values R knows). Note
that the IANA timezone values are case-sensitive. Note that intra-day data is converted to
an R datetime object (the standard \code{POSIXct} type) using the exchange timestamp in
the returned metadata, if present.}

\item{apikey}{(optional character) An API key override, if missing a value cached from
package startup is used. The startup looks for either a file in the per-package config
directory provided by \code{tools::R_user_dir} (for R 4.0.0 or later), or the
\code{TWELVEDATA_API_KEY} variable.}
}
\value{
The requested data is returned as a \code{data.frame} object.
}
\description{
Retrieve Reference Data for Symbol Search from \sQuote{twelvedata}
}
\details{
\code{ref_earliest_timestamp}.
}
\seealso{
\url{https://twelvedata.com/docs}
}
