% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_forex_pairs.R
\name{ref_forex_pairs}
\alias{ref_forex_pairs}
\title{Reference Data Accessor for Forex Pairs from \sQuote{twelvedata}}
\usage{
ref_forex_pairs(
  sym = "",
  as = c("data.frame", "raw"),
  currency_base = "",
  currency_quote = "",
  apikey
)
}
\arguments{
\item{sym}{(optional, character)  A (single or vector) currency pair according to ISO 4217 standard codes with slash(/) delimiter.}

\item{as}{(optional, character) A selector for the desired output format: one of
\dQuote{data.frame} (the default) or or \dQuote{raw}.}

\item{currency_base}{(optional, character) Base currency name. Default value is unset.}

\item{currency_quote}{(optional, character) Quote currency name. Default value is unset.}

\item{apikey}{(optional character) An API key override, if missing a value cached from
package startup is used. The startup looks for either a file in the per-package config
directory provided by \code{tools::R_user_dir} (for R 4.0.0 or later), or the
\code{TWELVEDATA_API_KEY} variable.}
}
\value{
The requested data is returned as a \code{data.frame} object.
}
\description{
Retrieve Reference Data for Forex Pairs from \sQuote{twelvedata}
}
\details{
\code{ref_forex_pairs}.
}
\seealso{
\url{https://twelvedata.com/docs}
}
