% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCurrencies.R
\name{getCurrencies}
\alias{getCurrencies}
\title{Download Currencies data}
\usage{
getCurrencies(token = "", live = FALSE, verbose = FALSE)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the list of available currencies.
}
\description{
Makes a request to the server, and returns an data.table object with information about available Currencies if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getCurrencies(token,live)
}
\seealso{
\code{\link{getETFs}} \code{\link{getBonds}} \code{\link{getStocks}}
}
\author{
Vyacheslav Arbuzov
}
