% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAccounts.R
\name{getAccounts}
\alias{getAccounts}
\title{Download available accounts}
\usage{
getAccounts(token = "", live = FALSE, verbose = FALSE)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the requested data with available accounts.
}
\description{
Makes a request to the server, and returns an data.table object with information about available accounts if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getAccounts(token,live)
}
\seealso{
\code{\link{getBalance}} \code{\link{getPortfolio}}
}
\author{
Vyacheslav Arbuzov
}
