#' @title Place market order
#'
#' @description this function will place your order in to account.
#'
#' @param token token from Tinkoff account
#' @param live live trading - TRUE or sandbox (paper) trading - FALSE (default)
#' @param figi internal tinkoff code for instrument
#' @param direction "Buy" or "Sell"
#' @param lots number of lots to buy
#' @details  As described by the official Tinkoff Investments documentation. If you want live trading, use sandbox=FALSE with live token
#' @return returns a list object containing the information about state of operation.
#' @note Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
#' @author Vyacheslav Arbuzov
#' @seealso \code{\link{limitOrder}}
#' @examples
#' paper_token = 'your_sandbox_token_from_tcs_account'
#' marketOrder(paper_token,figi='BBG005HLTYH9',direction='Buy',lots=1)
#'
#' live_token = 'your_live_token_from_tcs_account'
#' # remember that this command will place limit order in your live account !
#' marketOrder(live_token,live=TRUE,figi='BBG005HLTYH9',direction='Buy',lots=1)
#' @export

marketOrder = function(token = '', live = FALSE, figi = '', direction = NULL, lots = NULL)
{
  headers = add_headers("accept" = "application/json","Authorization" = paste("Bearer",token),"Content-Type" = "application/json")
  data = paste0('{\"lots\":',lots,',\"operation\":\"',direction,'\"}')
  url = paste0('https://api-invest.tinkoff.ru/openapi/',ifelse(live == FALSE,'sandbox/',''),'orders/market-order?figi=',figi)
  raw_data = POST(url, headers,body = data)
  return(content(raw_data, as = "parsed"))
}
