% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc6_mthds.R
\name{MC6_Methods}
\alias{MC6_Methods}
\alias{mc6_mthds}
\title{Load list of level 6 multiple-concentration flag methods}
\usage{
mc6_mthds()
}
\value{
A list functions
}
\description{
\code{mc6_mthds} returns a list of flag methods to be used 
during level 6 multiple-concentration processing.
}
\section{Available Methods}{


More information about the level 6 multiple-concentration processing is 
available in the package vignette, "Pipeline_Overview."

\describe{
  \item{singlept.hit.high}{The singlept.hit.high flag identifies 
  concentration series where the median response was greater than 3*bmad 
  only at the highest tested concentration and the series had an active 
  hit-call.}
  \item{singlept.hit.mid}{The singlept.hit.mid flag identifies concentration 
  series where the median response was greater than 3*bmad at only one 
  concentration (not the highest tested concentration) and the series had 
  an active hit-call.}
  \item{multipoint.neg}{The multipoint.neg flag identifies concentration 
  series with response medians greater than 3*bmad at multiple 
  concentrations and an inactive hit-call.}
  \item{gnls.lowconc}{The gnls.lowconc flag identifies concentration series
  where the gain-loss model won, the gain AC50 is less than the minimum 
  tested concentration, and the loss AC50 is less than the mean tested 
  concentration.}
  \item{noise}{The noise flag attempts to identify noisy concentration
  series by flagging series where the root mean square error for the series
  is greater than the cutoff for the assay endpoint.}
  \item{border.hit}{The border.hit flag identifies active concentration 
  series where the top parameter of the winning model was less than or equal 
  to 1.2*cut-off or the the activity probability was less than 0.9.}
  \item{border.miss}{The border.miss flag identifies inactive concentration
  series where either the Hill or gain-loss top parameter was greater than 
  or equal to 0.8*cut-off and the activity probability was greater than 0.5.}
  \item{overfit.hit}{The overfit.hit flag recalculates the model winner 
  after applying a small sample correction factor to the AIC values. If the 
  hit-call would be changed after applying the small sample correction 
  factor the series is flagged. Series with less than 5 concentrations where
  the hill model won and series with less than 7 concentrations where the 
  gain-loss model won are automatically flagged.}
  \item{efficacy.50}{The efficacy.50 flag identifies concentration series 
  with efficacy values (either the modeled top parameter for the winning
  model or the maximum median response) are less than 50 for percent activity
  data or log2(1.5) for fold induction data}
  \item{modlga.lowconc}{The modlga.lowconc flag identifies concentration series 
  with modl_ga (AC50) values less than the minimum tested concentration.}
}
}

\seealso{
\code{\link{mc6}}, \code{\link{Method functions}} to query what
methods get applied to each aeid
}
