% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ExpClipping}
\alias{ExpClipping}
\title{Builds and exports  the mesh representing the desired isosurface of an specific region of the dataset}
\usage{
ExpClipping(file_path, isovalue, verification, range_x, range_y, range_z,
  export_path)
}
\arguments{
\item{file_path}{A string: the path to the nhdr file}

\item{isovalue}{A number: the value corresponding to the desired isosurface}

\item{verification}{A boolean: determines whether the grid verification will be performed}

\item{range_x}{A vector contaning the clipping limits of the dataset in the x axis.}

\item{range_y}{A vector contaning the clipping limits of the dataset in the y axis.}

\item{range_z}{A vector contaning the clipping limits of the dataset in the z axis.}

\item{export_path}{A string: the path to a directory to put the mesh generated, following by the file name.}
}
\value{
The file of the mesh in the ply format.
}
\description{
This function returns the file (ply format) of the mesh of an specific region of the dataset.
}
\examples{
ExpClipping(system.file("extdata","f3.nhdr",package ="tcie"),0,FALSE,c(2,3),c(2,4),c(2,4),"m.ply")
ExpClipping(system.file("extdata","f3.nhdr",package ="tcie"),0,TRUE,c(2,3),c(2,4),c(2,4),"m.ply")
ExpClipping(system.file("extdata","f9.nhdr",package ="tcie"),0,TRUE,c(1,5),c(2,4),c(3,5),"m.ply")
}
