% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{log_posterior_neg}
\alias{log_posterior_neg}
\title{Function to evaluate the negative log posterior given a set of logged parameter values and observed BIS values.}
\usage{
log_posterior_neg(lpr, dat, mu, sig, ...)
}
\arguments{
\item{lpr}{logged PK-PD-error parameter values}

\item{dat}{data frame with columns corresponding to observed time and PD response values.}

\item{mu}{Mean of prior distribution.}

\item{sig}{Variance-covariance matrix of prior distribution.}

\item{...}{Arguments passed on to log-likelihood.}
}
\value{
Returns a numeric value representing the negative logged-posterior probability associated with a vector
parameter values 'lpr' with observations specified in 'dat' and prior parameters 'mu' and 'sigma'. Observations
are assumed to follow a (potentially truncated) normal distribution described in function 'log_likelihood'.
Parameter values have a multivariate normal prior distribution.
}
\description{
Function to evaluate the negative log posterior given a set of logged parameter values and observed BIS values.
}
