% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsFDR.R
\name{dsFDR}
\alias{dsFDR}
\title{Estimating the False Discovery Rate}
\usage{
dsFDR(gene_scores_perm, gene_scores_obs, n_perm, use_median = TRUE,
  doPlot = FALSE)
}
\arguments{
\item{gene_scores_perm}{a numeric matrix of size \code{G x n_perm} containing the permuted gene-wise scores
for \code{G} genes with \code{n_perm} permutations.}

\item{gene_scores_obs}{a vector of length \code{n} containing the observed gene-wise scores.}

\item{n_perm}{the number of perturbations. Default is \code{1000}.}

\item{use_median}{a logical flag indicating whether the median should be used to estimate
the true proportion of null features. If not, we use a range of quantiles of the permuted gene-wise scores
and the true proportion of null features is extrapolated from the limit of a smoothed estimate using the natural cubic spline.
Default is \code{TRUE}. See \emph{Storey et al.} for details}

\item{doPlot}{a logical flag indicating whether the plot of the natural cubic spline fit should be drawn.
Default is \code{FALSE}. Ignored if \code{use_median} is \code{TRUE}.}
}
\value{
A vector of estimating discrete false discovery rates
}
\description{
This function uses the permutation plug-in method to estimate the FDR.
}
\examples{
#rm(list=ls())
G <- 1000
nperm <- 100
G1 <- 300
G0 <- G-G1

gene_scores_perm <- matrix(rchisq(G*nperm, df=1), ncol=nperm, nrow=G)
gene_scores_obs <- c(rchisq(G1, df=10), rchisq(G0, df=1))

qvals <- dsFDR(gene_scores_perm, gene_scores_obs, nperm, use_median = FALSE, doPlot = TRUE)
summary(qvals)
eFDR_5pct <- mean(qvals[-(1:G1)]<0.05)
eTDR_5pct <- mean(qvals[1:G1]<0.05)
cat("FDR:", eFDR_5pct, " TDR:", eTDR_5pct, "\\n")
}
\references{
J. Li and R. Tibshirani (2013). Finding consistent patterns: A nonparametric approach
for identifying differential expression in RNA-seq data, \emph{Statistical Methods in Medical Research},
22(5): 519-536

Storey, J. D., & Tibshirani, R. (2003). Statistical significance for genome-wide studies.
\emph{Proceedings of the National Academy of Sciences}, 100(16), 9440-9445.
}
