% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{vis.logo}
\alias{vis.logo}
\title{Logo - plots for amino acid and nucletide profiles.}
\usage{
vis.logo(.data, .replace.zero.with.na = T, .jitter.width = 0.01,
  .jitter.height = 0.01, .dodge.width = 0.15)
}
\arguments{
\item{.data}{Output from the \code{kmer.profile} function.}

\item{.replace.zero.with.na}{if T then replace all zeros with NAs, therefore letters with
zero frequency wont appear at the plot.}

\item{.jitter.width, .jitter.height, .dodge.width}{Parameters to \code{position_jitterdodge}
for aligning text labels of letters.}
}
\value{
ggplot2 object
}
\description{
Plot logo-like graphs for visualising of nucleotide or amino acid motif sequences / profiles.
}
\examples{
\dontrun{
d <- kmer.profile(c('CASLL', 'CASSQ', 'CASGL'))
vis.logo(d)
}
}

