% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatools.R
\name{top.fun}
\alias{slice.fun}
\alias{top.fun}
\title{Get samples from a repertoire slice-by-slice or top-by-top and apply function to them.}
\usage{
top.fun(.data, .n, .fun, ..., .simplify = T)

slice.fun(.data, .size, .n, .fun, ..., .simplify = T)
}
\arguments{
\item{.data}{Data.frame, matrix, vector or any enumerated type or a list of this types.}

\item{.n}{Vector of values passed to head function for top.fun or the number of slices for slice.fun.}

\item{.fun}{Funtions to apply to every sample subset. First input argument is a data.frame, others are passed as \code{...}.}

\item{...}{Additional parameters passed to the .fun.}

\item{.simplify}{if T then try to simplify result to a vector or to a matrix if .data is a list.}

\item{.size}{Size of the slice for sampling for slice.fun.}
}
\value{
List of length length(.n) for top.fun or .n for slice.fun.
}
\description{
Functions for getting samples from data frames either by consequently applying
head functions (\code{top.fun}) or by getting equal number of rows in the moving window (\code{slice.fun})
and applying specified function to this samples.
}
\examples{
\dontrun{
# Get entropy of V-usage for the first 1000, 2000, 3000, ... clones.
res <- top.fun(immdata[[1]], 1000, entropy.seg)
# Get entropy of V-usage for the interval of clones with indices [1,1000], [1001,2000], ...
res <- top.fun(immdata[[1]], 1000, entropy.seg)
}
}

