% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{set.group.vector}
\alias{get.group.names}
\alias{set.group.vector}
\title{Set group attribute for vertices of a mutation network}
\usage{
set.group.vector(.G, .attr.name, .groups)

get.group.names(.G, .attr.name, .V = V(.G), .paste = T)
}
\arguments{
\item{.G}{Mutation network.}

\item{.attr.name}{Name of the new vertex attribute.}

\item{.groups}{List with integer vector with indices of subjects for each group.}

\item{.V}{Indices of vertices.}

\item{.paste}{if T then return character string with concatenated group names, else return list with character vectors
with group names.}
}
\value{
igraph object with new vertex attribute \code{.attr.name} with binary strings for \code{set.group.vector}.
Return character vector for \code{get.group.names}.
}
\description{
asdasd
}
\examples{
\dontrun{
data(twb)
twb.shared <- shared.repertoire(twb)
G <- mutation.network(twb.shared)
G <- set.group.vector(G, "twins", list(A = c(1,2), B = c(3,4)))  # <= refactor this
get.group.names(G, "twins", 1)       # "A|B"
get.group.names(G, "twins", 300)     # "A"
get.group.names(G, "twins", 1, F)    # list(c("A", "B"))
get.group.names(G, "twins", 300, F)  # list(c("A"))
# Because we have only two groups, we can assign more readable attribute.
V(G)$twin.names <- get.group.names(G, "twins")
V(G)$twin.names[1]  # "A|B"
V(G)$twin.names[300]  # "A"
}
}

